/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Task;
import com.ibm.hwmca.fw.task.HwmcaPanelTaskletData;
import com.ibm.hwmca.fw.task.LauncherTasklet;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressUpdateEvent;
import com.ibm.hwmca.fw.task.TaskInstance;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Array;

public abstract class HwmcaPanelTasklet
extends PanelTasklet {
    private HwmcaPanelTaskletData data;
    private static final String TRACE_MASKT = "XFRMHPTT";
    private static final String TRACE_MASKF = "XFRMHPTF";
    private static final String TRACE_MASKD = "XFRMHPTD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HwmcaObject;

    public void init(Object initData) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init(" + (initData == null ? "null" : initData.getClass().getName()) + ")");
        PanelTasklet parent = this.getParent();
        if (parent != null && parent instanceof HwmcaPanelTasklet) {
            this.data = ((HwmcaPanelTasklet)parent).data;
        } else {
            Object redirectData = this.getRedirectData();
            if (redirectData != null && redirectData instanceof HwmcaPanelTaskletData) {
                this.data = (HwmcaPanelTaskletData)redirectData;
                this.setRedirectData(null);
            } else {
                Trace.trace(TRACE_MASKF, "redirectData=" + (redirectData == null ? "null" : redirectData.getClass().getName()));
            }
        }
        if (this.data != null) {
            LauncherTasklet lt = this.data.getLauncherTasklet();
            if (lt != null) {
                Trace.trace(TRACE_MASKF, "setting task instance data to: " + lt.getTaskData());
                TaskInstance.getTaskInstance().set(lt.getTaskData());
            } else {
                Trace.trace(TRACE_MASKF, "skipping setting task instance data since LauncherTasklet is null");
            }
        } else {
            Trace.trace(TRACE_MASKF, "skipping setting task instance data since HwmcaPanelTaskletData is null");
        }
        super.init(initData);
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public Task getTask() {
        this.checkState();
        return this.data.getTask();
    }

    public HwmcaObject getObjectForId(ObjectId id) {
        this.checkState();
        return (HwmcaObject)this.data.getObjects().get(id);
    }

    public HwmcaObject[] getObjectsForIds(ObjectId[] ids) {
        return this.getObjectsForIds(ids, null);
    }

    public HwmcaObject[] getObjectsForIds(ObjectId[] ids, Class resultClass) {
        Trace.trace(TRACE_MASKT, "-> getObjectsForIds(ids=" + ids + ", resultClass=" + resultClass + ")");
        this.checkState();
        HwmcaObject[] result = null;
        if (ids != null) {
            if (ids.length == 0 && resultClass == null) {
                throw new IllegalArgumentException("Id array cannot be null or of zero length: ids=" + ids);
            }
            if (resultClass == null) {
                resultClass = this.data.getObjects().get(ids[0]).getClass();
            }
            if (!(class$com$ibm$hwmca$fw$managed$HwmcaObject == null ? (class$com$ibm$hwmca$fw$managed$HwmcaObject = HwmcaPanelTasklet.class$("com.ibm.hwmca.fw.managed.HwmcaObject")) : class$com$ibm$hwmca$fw$managed$HwmcaObject).isAssignableFrom(resultClass)) {
                throw new IllegalArgumentException("Result class does not derive from HwmcaObject: " + resultClass);
            }
            result = (HwmcaObject[])Array.newInstance(resultClass, ids.length);
            int ix = 0;
            while (ix < ids.length) {
                result[ix] = (HwmcaObject)this.data.getObjects().get(ids[ix]);
                if (result[ix] == null) {
                    throw new IllegalArgumentException("ObjectId does not correspond to a target: " + ids[ix]);
                }
                ++ix;
            }
        }
        Trace.trace(TRACE_MASKT, "<- getObjectsForIds(returns " + result + ")");
        return result;
    }

    public void updateProgress(ProgressUpdateEvent evt) throws TaskletException {
        int status;
        this.checkState();
        super.updateProgress(evt);
        ProgressData progData = evt.getProgressData();
        if (progData.getObjectId() != null && (status = progData.getCompletionStatus()) != -1 && status != 0) {
            this.unbusyTarget(progData.getObjectId());
        }
    }

    private void checkState() {
        if (this.data == null) {
            throw new IllegalStateException("The panel object database has not been initialized.  Has method HwmcaPanelTasklet.init been overriden without a call to super()?");
        }
    }

    protected void unbusyTarget(ObjectId target) {
        LauncherTasklet lt = this.data.getLauncherTasklet();
        if (lt != null) {
            lt.unbusyTarget(target);
        }
    }

    protected HwmcaPanelTaskletData getData() {
        return this.data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

